/*****************************************************************************
*                                 MACRO                                      *
******************************************************************************/
#define IPC_MAX_MSGSIZE	    			256				/* max received message size */
#define NL_TBS_WLAN0_PID_ENTRY_NAME		"nl_pid_wl0"	/* pid entry name for 2.4G band */
#define NL_TBS_WLAN1_PID_ENTRY_NAME		"nl_pid_wl1"	/* pid entry name for 5.8G band */

/*****************************************************************************
*                                 ENUM                                       *
******************************************************************************/
/* private netlink operate command list */
enum {
	NL_CMD_WLAN_WSC_STATUS_CHG	/* wps status change from unconfigured to configured */
};

/*****************************************************************************
*                               FUNCTION DECLARE                             *
******************************************************************************/
extern int IPC_GetSocket( void );
extern int IPC_RecvMsg( int *cmd, char *content, int size );
extern int IPC_SendMsg( int cmd, char *content );
extern int IPC_ModuleInit( void );
extern void IPC_ModuleDestory( void );

